##################################################################
# R code: Exercise 10.10
# File: Table-10-3.r
#
# Ff = forward with fitted residuals; Fp = forward with predictive 
# residuals; "Warming up = 100"; T = 100; B = 1,000; m = 500.
#
# Reference:
# Pan, L. and Politis, D.N. (2016).
#   Bootstrap prediction intervals for linear, nonlinear and 
#   nonparametric autoregressions (with discussion).
#   Journal of Statistical Planning and Inference, 177, 1-27.
#   DOI: 10.1016/j.jspi.2014.10.003.
##################################################################
f <- function(x){# SETAR(2;1,1) model with d=1, and N(0,1) errors
  if(x<=0) return(0.5*x)
  if(x>0)  return(-0.4*x)
}
sim <- function(f,n){        # Simulation
  temp    <- rep(0,(n+100))
  temp[1] <- 1
  e <- rnorm((n+100),0,1)    # e <- rt(n+100,df=5) Student t(5) 
  for (i in 1:((n-1)+100)){
    temp[i+1] <- f(temp[i])+e[i+1]
  }
  u <- temp[101:(100+n)] 
}
bootstrap=function(u,fhat,residuals){
  bb    = rep(0,(n+100))
  bb[1] = u[1]
  estar = sample(residuals,(n+101),replace=TRUE)
  for (i in 1:(n+99)){
    bb[i+1] <- fhat(bb[i])+estar[i+1]
  }
  b  = bb[101:(n+100)]
  fv = fhat(u[n])+estar[(n+101)]#X_{n+1}^*
  list(b=b,fv=fv)
}
n = 100    # sample size
TAR.sim <- function(f,n){
  ###### Simulation and model estimation ######
  u   <- sim(f,n)
  x   <- u[1:(n-1)]
  y   <- u[2:n]
  idx <- which(x>=0)
  if(length(idx)>=2 & length(idx)<=n-3){   
    fit1 <- lm(y[idx]~x[idx])
    fit2 <- lm(y[-idx]~x[-idx])
    while(abs(fit1$coef[2])>=1 | abs(fit2$coef[2])>=1){
      u <- sim(f,n)
      x <- u[1:(n-1)]
      y <- u[2:n]
      idx <- which(x>=0)
      if(length(idx)>n-3){
        fit1 <- lm(y[idx]~x[idx])
        fit2 <- fit1
      }
      if(length(idx)<2){
        fit2 <- lm(y[-idx]~x[-idx])
        fit1 <- fit2
      }
      if(length(idx)>=2 & length(idx)<=n-3){
        fit1 <- lm(y[idx]~x[idx])
        fit2 <- lm(y[-idx]~x[-idx])
      } 
    }
    fres = c(fit1$resid,fit2$resid)
    fhat <- function(x){
      if(x>=0) y <- fit1$coef[2]*x+fit1$coef[1] 
      if(x<0)  y <- fit2$coef[2]*x+fit2$coef[1]     
    }    
  }
  else{
    fit  <- lm(y~x)
    fres <- fit$resid
    while(abs(fit$coef[2])>=1){
      u   <- sim(f,n)
      x   <- u[1:(n-1)]
      y   <- u[2:n]
      fit <- lm(y~x)
    }
    fhat <- function(x) fit$coef[2] * x +fit$coef[1]
  }
  yhat     <- fhat(u[n])       # Fitted value
  fres     <- fres-mean(fres)  # Fitted residuals
  sigmahat <- sd(fres)         # Sigma  
  resid    <- rep(0,(n-1))     # Predictive residuals
  for (i in 1:(n-1)){
    xtemp <- x[-i]
    ytemp <- y[-i]
    idx.temp <- which(xtemp*x[i]>=0)
    if(length(idx.temp)>=2){
      xtemp   <- xtemp[idx.temp]
      ytemp   <- ytemp[idx.temp]
      tempfit <- lm(ytemp~xtemp)
    } 
    else{
      tempfit <- lm(ytemp~xtemp)
    }
    resid[i]  <- y[i]-predict(tempfit,data.frame(xtemp=x[i]))    
  }
  pres <- resid-mean(resid)
   
  ###### Bootstrap ######
  Ffstarhat <- rep(0,1000)
  Ffstar    <- rep(0,1000)
  Fsfsd     <- rep(0,1000)
  for (i in 1:1000){
    result <- bootstrap(u,fhat,fres)
    ustar  <- result$b
    xstar  <- ustar[1:(n-1)]
    ystar  <- ustar[2:n]
    idx.star <- which(xstar>=0)
    if(length(idx.star)<=n-3 & length(idx.star)>=2){
      fitstar1 <- lm(ystar[idx.star] ~ xstar[idx.star])  
      fitstar2 <- lm(ystar[-idx.star] ~ xstar[-idx.star])  
      fhatstar <- function(x){
        if(x>=0) y <- fitstar1$coef[2]*x+fitstar1$coef[1] 
        if(x<0)  y <- fitstar2$coef[2]*x+fitstar2$coef[1]        
      }
      sigmastar <- sd(c(fitstar1$res,fitstar2$res))
     } 
      else{
        fitstar   <- lm(ystar~xstar)
        fhatstar  <- function(x) fitstar$coef[2]*x+fitstar$coef[1] 
        sigmastar <- sd(fitstar$res)
    }
    Ffstarhat[i] <- fhatstar(u[n])
    Ffstar[i]    <- result$fv
    Fsfsd[i]     <- (Ffstar[i] -Ffstarhat[i])/sigmastar    
  }
  Fpstarhat <- rep(0,1000)
  Fpstar    <- rep(0,1000)
  Fspsd     <- rep(0,1000)
  for (i in 1:1000){
    result <- bootstrap(u,fhat,pres)
    ustar  <- result$b
    xstar  <- ustar[1:(n-1)]
    ystar  <- ustar[2:n]
    idx.star <- which(xstar>=0)
    if(length(idx.star)<=n-3 & length(idx.star)>=2){
      fitstar1 <- lm(ystar[idx.star] ~ xstar[idx.star])  
      fitstar2 <- lm(ystar[-idx.star] ~ xstar[-idx.star])  
      fhatstar <- function(x){
        if(x>=0) y <- fitstar1$coef[2]*x+fitstar1$coef[1] 
        if(x<0)  y <- fitstar2$coef[2]*x+fitstar2$coef[1]        
      }
      sigmastar <- sd(c(fitstar1$res,fitstar2$res))
    }
   else{
      fitstar   <- lm(ystar~xstar)
      fhatstar  <- function(x) fitstar$coef[2]*x+fitstar$coef[1] 
      sigmastar <- sd(fitstar$res)
    }
    sigmastar   <- sd(c(fitstar1$res,fitstar2$res))
    Fpstarhat[i]<- fhatstar(u[n])
    Fpstar[i]   <- result$fv
    Fspsd[i]    <- (Fpstar[i] -Fpstarhat[i])/sigmastar
  }
  ####### Get the FI interval #######
  # Ff (fitted residuals)
  Ffdown <- yhat+quantile(Ffstar-Ffstarhat,.025)
  Ffup   <- yhat+quantile(Ffstar-Ffstarhat,.975)
  Ffl    <- Ffup-Ffdown
  # Fp (predicted residuals)
  Fpdown <- yhat+quantile(Fpstar-Fpstarhat,.025)
  Fpup   <- yhat+quantile(Fpstar-Fpstarhat,.975)
  Fpl    <- Fpup-Fpdown
  # 1,000 future values
  truevalue <- f(u[n]) + rnorm(1000)
  Ff <- 0
  Fp <- 0
  for (i in 1:1000){
    if((truevalue[i]<Ffup) & truevalue[i]>Ffdown)
      Ff <- Ff+1
    if((truevalue[i]<Fpup) & truevalue[i]>Fpdown)
      Fp <- Fp+1
   }
  Ffc <- Ff/1000
  Fpc <- Fp/1000  
  list(Ffc=Ffc,Fpc=Fpc,Ffl=Ffl,Fpl=Fpl)       
}
Ffc <- rep(NA,500)
Fpc <- rep(NA,500)
Ffl <- rep(NA,500)
Fpl <- rep(NA,500)
for (i in 1:500){
  set.seed(5*i)
  results <- TAR.sim(f,n)
  Ffc[i]  <- results$Ffc
  Fpc[i]  <- results$Fpc
  Ffl[i]  <- results$Ffl
  Fpl[i]  <- results$Fpl
  if(i%%20==0) print(i)
}
print(mean(Ffc))
print(mean(Fpc))
print(mean(Ffl))
print(mean(Fpl))
print(sd(Ffl))
print(sd(Fpl))
